// Example 4a: 7-Segment Decoder - C Version
#include <hidef.h>      /* common defines and macros */
#include <mc9s12dg256.h>     /* derivative information */
#pragma LINK_INFO DERIVATIVE "mc9s12dg256b"

#include "main_asm.h" /* interface to the assembly module */

void delay(void);

void main(void) {
  const char seg7tbl[] = {
     0x3F,0x06,0x5B,0x4f,
		 0x66,0x6D,0x7D,0x07,
		 0x7F,0x6F,0x77,0x7C,
		 0x39,0x5E,0x79,0x71
  };
  int i;
  PLL_init();           // set system clock frequency to 24 MHz
  seg7_enable();        // enable 7-segment display
  led_disable();        // disable LEDs
  while(1){
    for(i = 0; i < 16; i++) {
       PORTB = seg7tbl[i];
       delay();
    }
  }
}

void delay() {
  int i,j;
  for(i = 0; i < 500; i++) {
    for(j = 0; j < 6248; j++) {
    }
  }
}

        






